{*load CSS dynamically*}
<link rel="stylesheet" type="text/css" href="{$url_css}">

<div v-cloak id="coe-basics-create-db-backup-app">
    <div class="container-fluid">
        {* HEADER *}
        <div class="h4">
            {txt key=TEXT_COE_BASICS_BACKUP_INFO}
        </div>
        <div class="row">
            <div class="col-sm-12">
                <p>
                    Size: approx. {{ db_size }} MB
                </p>
                <p>
                    Tables: {{ db_table_cnt }}
                </p>

            </div>
            <div class="col-sm-12" style="margin-top: 20px">
                <button :disabled="(started||completed)" :class="[(completed) ? 'btn-success' : 'btn-info']"
                        class="btn"
                        @click="startCreateDbBackup()">
                    <span v-if="completed">COMPLETED</span>
                    <span v-else-if="started"><i class="fas fa-stop"></i> Processing ...</span>
                    <span v-else>{txt key=TEXT_START}</span>
                </button>
            </div>
            {* Progress bar *}
            <div class="col-sm-12" style="margin-top: 20px">
                <h2 class="sub-header">
                    <p>{txt key=TEXT_COE_BASICS_PROGRESS}:</p>
                </h2>
                <div id="db-backup-progress" class="progress">
                    <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" :style="{ width: progressValue + '%'}" :aria-valuenow="progressValue"
                         aria-valuemin="0"
                         aria-valuemax="100">{{ progressValue }}%
                    </div>
                </div>
            </div>

            {* log *}
            <div class="col-sm-12" style="margin-top: 20px">
                <div class="table-responsive" style="max-height: 35vh">
                    <table class="table table-striped">
                        <thead>
                        <tr>
                            <th class="col-md-3">#</th>
                            <th>Time</th>
                            <th>Message</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr v-show="started && !completed">
                            <td colspan="3" class="col-md-1">
                                {txt key=TEXT_LOADING} ...
                            </td>
                        </tr>
                        <tr v-for="logItem in logMsgReverse">
                            <td class="col-md-1">{{ logItem.id }}</td>
                            <td class="col-md-2">{{ logItem.time }}</td>
                            <td>{{ logItem.msg }}</td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    if (typeof coe_axios_token === 'undefined') {
        var coe_axios_token = '{$coe_axios_token}';
    }

    //make use of coe_basics functionality: mount script loader => perform work after loaded / initialize preview
    coeBasics_loadDynamicScript(() => {
        {*coeBasicsCreateDbBackupInitialize({$data|json_encode});*}
        coeBasicsCreateDbBackupInitialize({$data|json_encode});
        //coeBasicsCreateDbBackup(backup_size_total);
    }, '{$url_script}');
    // $url_script = "../plugins/coe_basics/javascript/create_db_backup.js"

</script>