function coeBasicsCreateDbBackupInitialize(data) {

    //debugging
    Vue.config.devtools = true

    // ***************  axios cfg ******************
    const axiosBaseUrl = "adminHandler.php?coe_read_postinput=" + coe_axios_token;
    const axiosBaseParams = {
        plugin: 'coe_basics',
        load_section: 'coe_basics_db_backup',
        //todo: sec key?
    }
    // ************** END axios cfg ****************

    //update interval in ms
    const updateInterval = 1000

    //settings
    let db_size = data.db_size.size_mb || 'unknown'
    let db_table_cnt = data.db_table_cnt || 'unknown'
    const tmp_log = data.tmp_log || 'unknown'

    // ***************  VUE APP ******************
    var coe_basics_create_db_backup_app = new Vue({
        el: '#coe-basics-create-db-backup-app',
        data: {
            logMsg: [],
            lastLogLine: 0,
            started: false,
            completed: false,
            db_size: db_size,
            db_table_cnt: db_table_cnt,
            tables_processed: 0,
            updateIntervalFlag: false,
            startTime: 0
        },
        computed: {
            logMsgReverse() {
                return this.logMsg.slice().reverse();
            },
            progressValue() {
                if (this.db_table_cnt == 'unknown') {
                    return 0;
                } else {
                    return Math.floor((this.tables_processed * 100) / this.db_table_cnt)
                }
            }
        },
        methods: {
            startCreateDbBackup: function () {

                this.logMsg = []
                this.started = true
                this.startTime = performance.now()

                let logEntry = {
                    id: 'Started',
                    time: new Date().toISOString(),
                    msg: "DB Backup started, please wait ...",
                }
                this.logMsg.push(logEntry)

                let params = axiosBaseParams
                params.pg = 'createDbBackup'
                //params.runInBackground = false
                //params.automation_id = cslp_automation_force_data.id
                axios.post(axiosBaseUrl, params).then(response => {
                    this.completed = true
                    clearTimeout(this.updateIntervalFlag)

                    //ensure 100% is shown
                    this.tables_processed = this.db_table_cnt
                    // console.log('backup completed')
                    // console.log(response.data)
                    let logEntry = {
                        id: 'COMPLETED',
                        time: new Date().toISOString(),
                        msg: response.data.msg
                    }
                    this.logMsg.push(logEntry)
                });

                this.updateDbBackupProgress()
            },

            updateDbBackupProgress: function () {

                //if log file specified => read progress from log
                //else: simply updated counter
                if (tmp_log != 'unknown') {
                    // get progress from tmp log
                    // hint: => if doing a ajax request => DB queries are executed => delay / request not working properly
                    //  => do not "touch" shop system during backup, thus simply read file contents (log) using JS?
                    this.readLogFile()
                } else {
                    let logEntry = {
                        id: this.logMsg.length + 1,
                        time: new Date().toISOString(),
                        msg: "Backup in progress, please wait. Time elapsed: " + ((performance.now() - this.startTime) / 1000)
                    }
                    this.logMsg.push(logEntry)
                }

                //set timeout and update again
                if (this.completed) {
                    Ext.Msg.alert('FINISHED', r.msg);
                } else {
                    this.updateIntervalFlag = setTimeout(this.updateDbBackupProgress, updateInterval)
                }

            },
            readLogFile: function () {

                let file = tmp_log

                //if backup is completed => log is removed => todo catch 404
                axios.get(file).then(response => {
                    let contentArr = response.data.split(/\r\n|\r|\n/)
                    let newLines = contentArr.slice(this.lastLogLine)
                    this.lastLogLine = contentArr.length

                    newLines.forEach(element => {
                        //update process counter: simple count "tables processed"
                        if (element.indexOf('table structure for table') >= 0) {
                            this.tables_processed++;
                        }
                        let logEntry = {
                            id: this.logMsg.length + 1,
                            time: new Date().toISOString(),
                            msg: element,
                        }
                        this.logMsg.push(logEntry)
                    });
                }).catch(function (error) {
                    //console.log(error.toJSON());
                })
            }
        },
        mounted() {
            // alert('good morning')
        },
    })
    // *************** END VUE APP ******************
}