/*hint - usage:
coeBasics_loadDynamicScript(() => {
    // work to do after the library has been loaded
    // alert('hello world');
}, "../plugins/coe_basics/javascript/load_me.js");
*/

//dynamic lib loading while ensuring it's only loaded once
const coeBasics_loadDynamicScript = (callback, urlToScript) => {

    const scriptId = urlToScript.replace(/\W/g, '_');
    const existingScript = document.getElementById(scriptId);
    if (!existingScript) {
        const script = document.createElement('script');
        script.src = urlToScript;
        script.id = scriptId;
        document.body.appendChild(script);
        script.onload = () => {
            if (callback) callback();
        };
    }

    if (existingScript && callback) callback();
};